<?php

namespace VM\NotesBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * GroupNote
 *
 * @ORM\Table(name="groupnotes")
 * @ORM\Entity()
 */
class GroupNote
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="page_id", type="integer", nullable=true)
     */
    private $page_id;

    /**
     * @var integer
     *
     * @ORM\Column(name="group_id", type="integer")
     */
    private $group_id;

    /**
     * @var integer
     *
     * @ORM\Column(name="note_id", type="integer")
     */
    private $note_id;

    /**
     * @var integer
     *
     * @ORM\Column(name="task_in_book_id", type="integer", nullable=true)
     */
    private $task_in_book_id;

    /**
     * @var integer
     *
     * @ORM\Column(name="book_id", type="integer")
     */
    private $book_id;

    /**
     * @var \Datetime
     *
     * @ORM\Column(name="note_timestamp", type="datetime")
     */
    private $note_timestamp;

    /**
     * @var boolean
     *
     * @ORM\Column(name="deleted", type="boolean")
     */
    private $deleted;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set page_id
     *
     * @param integer $pageId
     * @return GroupNote
     */
    public function setPageId($pageId)
    {
        $this->page_id = $pageId;
    
        return $this;
    }

    /**
     * Get page_id
     *
     * @return integer 
     */
    public function getPageId()
    {
        return $this->page_id;
    }

    /**
     * Set group_id
     *
     * @param integer $groupId
     * @return GroupNote
     */
    public function setGroupId($groupId)
    {
        $this->group_id = $groupId;
    
        return $this;
    }

    /**
     * Get group_id
     *
     * @return integer 
     */
    public function getGroupId()
    {
        return $this->group_id;
    }

    /**
     * Set note_id
     *
     * @param integer $noteId
     * @return GroupNote
     */
    public function setNoteId($noteId)
    {
        $this->note_id = $noteId;
    
        return $this;
    }

    /**
     * Get note_id
     *
     * @return integer 
     */
    public function getNoteId()
    {
        return $this->note_id;
    }

    /**
     * Set task_in_book_id
     *
     * @param integer $taskInBookId
     * @return GroupNote
     */
    public function setTaskInBookId($taskInBookId)
    {
        $this->task_in_book_id = $taskInBookId;
    
        return $this;
    }

    /**
     * Get task_in_book_id
     *
     * @return integer 
     */
    public function getTaskInBookId()
    {
        return $this->task_in_book_id;
    }

    /**
     * Set book_id
     *
     * @param integer $bookId
     * @return GroupNote
     */
    public function setBookId($bookId)
    {
        $this->book_id = $bookId;
    
        return $this;
    }

    /**
     * Get book_id
     *
     * @return integer 
     */
    public function getBookId()
    {
        return $this->book_id;
    }

    /**
     * Set note_timestamp
     *
     * @param \DateTime $noteTimestamp
     * @return GroupNote
     */
    public function setNoteTimestamp($noteTimestamp)
    {
        $this->note_timestamp = $noteTimestamp;
    
        return $this;
    }

    /**
     * Get note_timestamp
     *
     * @return \DateTime 
     */
    public function getNoteTimestamp()
    {
        return $this->note_timestamp;
    }

    /**
     * Set deleted
     *
     * @param boolean $deleted
     * @return GroupNote
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
    
        return $this;
    }

    /**
     * Get deleted
     *
     * @return boolean 
     */
    public function getDeleted()
    {
        return $this->deleted;
    }
}